<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255);
			$table->string('email', 255)->unique();
			$table->string('phone', 255)->nullable();
			$table->bigInteger('points')->nullable();
			$table->string('password', 255);
			$table->tinyInteger('is_active')->default('0');
			$table->enum('status', array('pending', 'accepted', 'rejected'));
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}