<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255)->nullable();
			$table->string('description')->nullable();
			$table->integer('level_id');
			$table->integer('doctor_id');
			$table->double('price');
			$table->double('discount_value')->nullable();
			$table->enum('disount_type', array('percent', 'value'))->nullable();
			$table->double('price_after_discount')->nullable();
			$table->tinyInteger('active')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}