<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('phone')->nullable();
			$table->string('email', 255)->unique();
			$table->string('password');
			$table->tinyInteger('is_active')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}