<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRepresentativesTable extends Migration {

	public function up()
	{
		Schema::create('representatives', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('fk_place_id')->unsigned();
			$table->bigInteger('fk_position_id')->unsigned();
			$table->bigInteger('position_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email')->unique();
			$table->string('phone')->unique()->nullable();
			$table->string('note')->nullable();
			$table->boolean('contract');
		});
	}

	public function down()
	{
		Schema::drop('representatives');
	}
}