<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function position()
    {
        return $this->belongsTo('Position', 'fk_position_id');
    }

    public function place()
    {
        return $this->belongsTo('Place', 'fk_place_id');
    }

}