<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTable extends Migration {

	public function up()
	{
		Schema::create('places', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('fk_company_id')->unsigned();
			$table->bigInteger('fk_place_type_id')->unsigned();
			$table->bigInteger('fk_address_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('email');
			$table->string('phone');
			$table->string('ico');
			$table->string('dic');
		});
	}

	public function down()
	{
		Schema::drop('places');
	}
}