<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SessionTask extends Eloquent {

	protected $table = 'stasks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function session()
	{
		return $this->belongsTo('Session', 'fk_session_id');
	}

	public function responsible()
	{
		return $this->belongsToMany('Representative', 'representatives_stasks_pivot');
	}

}