<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('representatives', function(Blueprint $table) {
			$table->foreign('fk_place_id')->references('id')->on('places')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('representatives', function(Blueprint $table) {
			$table->foreign('fk_position_id')->references('id')->on('positions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('fk_country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('fk_company_type_id')->references('id')->on('company_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('fk_contract_id')->references('id')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('fk_company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('fk_place_type_id')->references('id')->on('company_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('fk_address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('fk_place_id')->references('id')->on('places')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('fk_position_id')->references('id')->on('positions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('meetings', function(Blueprint $table) {
			$table->foreign('fk_company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mtasks', function(Blueprint $table) {
			$table->foreign('fk_meeting_id')->references('id')->on('meetings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->foreign('fk_company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_countries_pivot', function(Blueprint $table) {
			$table->foreign('fk_company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('company_countries_pivot', function(Blueprint $table) {
			$table->foreign('fk_country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stasks', function(Blueprint $table) {
			$table->foreign('fk_session_id')->references('id')->on('sessions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('representatives_stasks_pivot', function(Blueprint $table) {
			$table->foreign('fk_stask_id')->references('id')->on('stasks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('representatives_stasks_pivot', function(Blueprint $table) {
			$table->foreign('fk_representative_id')->references('id')->on('representatives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('representatives_mtasks_pivot', function(Blueprint $table) {
			$table->foreign('fk_mtask_id')->references('id')->on('mtasks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('representatives_mtasks_pivot', function(Blueprint $table) {
			$table->foreign('fk_representative_id')->references('id')->on('representatives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('representative_session', function(Blueprint $table) {
			$table->foreign('fk_representative_id')->references('id')->on('representatives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('representative_session', function(Blueprint $table) {
			$table->foreign('fk_session_id')->references('id')->on('sessions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('representative_meeting', function(Blueprint $table) {
			$table->foreign('fk_representative_id')->references('id')->on('representatives')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('representative_meeting', function(Blueprint $table) {
			$table->foreign('fk_meeting_id')->references('id')->on('meetings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('session_user', function(Blueprint $table) {
			$table->foreign('fk_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('session_user', function(Blueprint $table) {
			$table->foreign('fk_session_id')->references('id')->on('sessions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('meeting_user', function(Blueprint $table) {
			$table->foreign('fk_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('meeting_user', function(Blueprint $table) {
			$table->foreign('fk_meeting_id')->references('id')->on('meetings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('representatives', function(Blueprint $table) {
			$table->dropForeign('representatives_fk_place_id_foreign');
		});
		Schema::table('representatives', function(Blueprint $table) {
			$table->dropForeign('representatives_fk_position_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_fk_country_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_fk_company_type_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_fk_contract_id_foreign');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_fk_company_id_foreign');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_fk_place_type_id_foreign');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_fk_address_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_fk_place_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_fk_position_id_foreign');
		});
		Schema::table('meetings', function(Blueprint $table) {
			$table->dropForeign('meetings_fk_company_id_foreign');
		});
		Schema::table('mtasks', function(Blueprint $table) {
			$table->dropForeign('mtasks_fk_meeting_id_foreign');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->dropForeign('sessions_fk_company_id_foreign');
		});
		Schema::table('company_countries_pivot', function(Blueprint $table) {
			$table->dropForeign('company_countries_pivot_fk_company_id_foreign');
		});
		Schema::table('company_countries_pivot', function(Blueprint $table) {
			$table->dropForeign('company_countries_pivot_fk_country_id_foreign');
		});
		Schema::table('stasks', function(Blueprint $table) {
			$table->dropForeign('stasks_fk_session_id_foreign');
		});
		Schema::table('representatives_stasks_pivot', function(Blueprint $table) {
			$table->dropForeign('representatives_stasks_pivot_fk_stask_id_foreign');
		});
		Schema::table('representatives_stasks_pivot', function(Blueprint $table) {
			$table->dropForeign('representatives_stasks_pivot_fk_representative_id_foreign');
		});
		Schema::table('representatives_mtasks_pivot', function(Blueprint $table) {
			$table->dropForeign('representatives_mtasks_pivot_fk_mtask_id_foreign');
		});
		Schema::table('representatives_mtasks_pivot', function(Blueprint $table) {
			$table->dropForeign('representatives_mtasks_pivot_fk_representative_id_foreign');
		});
		Schema::table('representative_session', function(Blueprint $table) {
			$table->dropForeign('representative_session_fk_representative_id_foreign');
		});
		Schema::table('representative_session', function(Blueprint $table) {
			$table->dropForeign('representative_session_fk_session_id_foreign');
		});
		Schema::table('representative_meeting', function(Blueprint $table) {
			$table->dropForeign('representative_meeting_fk_representative_id_foreign');
		});
		Schema::table('representative_meeting', function(Blueprint $table) {
			$table->dropForeign('representative_meeting_fk_meeting_id_foreign');
		});
		Schema::table('session_user', function(Blueprint $table) {
			$table->dropForeign('session_user_fk_user_id_foreign');
		});
		Schema::table('session_user', function(Blueprint $table) {
			$table->dropForeign('session_user_fk_session_id_foreign');
		});
		Schema::table('meeting_user', function(Blueprint $table) {
			$table->dropForeign('meeting_user_fk_user_id_foreign');
		});
		Schema::table('meeting_user', function(Blueprint $table) {
			$table->dropForeign('meeting_user_fk_meeting_id_foreign');
		});
	}
}