<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MeetingTask extends Eloquent {

	protected $table = 'mtasks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function meeting()
	{
		return $this->belongsTo('Meeting', 'fk_meeting_id');
	}

	public function responsible()
	{
		return $this->belongsToMany('Representative', 'representatives_mtasks_pivot');
	}

}