<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Place extends Eloquent {

	protected $table = 'places';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function company()
	{
		return $this->belongsTo('Company', 'fk_company_id');
	}

	public function type()
	{
		return $this->belongsTo('PlaceType', 'fk_place_type_id');
	}

	public function address()
	{
		return $this->belongsTo('Address', 'fk_address_id');
	}

	public function users()
	{
		return $this->hasMany('User');
	}

	public function representatives()
	{
		return $this->hasMany('Representative');
	}

}