<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Representative extends Eloquent {

	protected $table = 'representatives';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function place()
	{
		return $this->hasOne('Place', 'fk_place_id');
	}

	public function position()
	{
		return $this->belongsTo('Position', 'fk_position_id');
	}

}