<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MeetingTask extends Model 
{

    protected $table = 'mtasks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function meeting()
    {
        return $this->belongsTo('Meeting', 'fk_meeting_id');
    }

    public function responsible()
    {
        return $this->belongsToMany('Representative', 'representatives_mtasks_pivot');
    }

}