<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Position extends Model 
{

    protected $table = 'positions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->hasMany('User');
    }

    public function representatives()
    {
        return $this->hasMany('Representative');
    }

}