<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('post', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('post')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('post_like', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('post_like', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('post')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comment_like', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('comment_like', function(Blueprint $table) {
			$table->foreign('comment_id')->references('id')->on('comment')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_follow', function(Blueprint $table) {
			$table->foreign('source_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_follow', function(Blueprint $table) {
			$table->foreign('target_id')->references('id')->on('user')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('post', function(Blueprint $table) {
			$table->dropForeign('post_user_id_foreign');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->dropForeign('comment_user_id_foreign');
		});
		Schema::table('comment', function(Blueprint $table) {
			$table->dropForeign('comment_post_id_foreign');
		});
		Schema::table('post_like', function(Blueprint $table) {
			$table->dropForeign('post_like_user_id_foreign');
		});
		Schema::table('post_like', function(Blueprint $table) {
			$table->dropForeign('post_like_post_id_foreign');
		});
		Schema::table('comment_like', function(Blueprint $table) {
			$table->dropForeign('comment_like_user_id_foreign');
		});
		Schema::table('comment_like', function(Blueprint $table) {
			$table->dropForeign('comment_like_comment_id_foreign');
		});
		Schema::table('user_follow', function(Blueprint $table) {
			$table->dropForeign('user_follow_source_id_foreign');
		});
		Schema::table('user_follow', function(Blueprint $table) {
			$table->dropForeign('user_follow_target_id_foreign');
		});
	}
}