<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('sku');
			$table->text('description');
			$table->integer('price')->unsigned();
			$table->boolean('active')->default(0);
			$table->timestamps();
			$table->softDeletes();
			$table->string('quantity');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}