<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function images()
    {
        return $this->hasMany('Product_Image');
    }

    public function attachments()
    {
        return $this->hasMany('Attachment');
    }

}