<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('manufacture');
			$table->string('manufacture_year');
			$table->boolean('status');
			$table->boolean('slider');
			$table->text('description');
			$table->string('excerpt', 150);
			$table->string('capacity');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}