<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupsTable extends Migration {

	public function up()
	{
		Schema::create('groups', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 120);
			$table->integer('management_commissions');
			$table->string('invitation_code', 300);
			$table->string('logo', 300)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('groups');
	}
}