<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('name', 'age', 'blood_type_id', 'bags_num', 'hospital_name', 'hospital_address', 'longitud', 'latitude', 'city_id', 'phone', 'client_id', 'description');

	public function blood_type()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

}