<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFinMovimentosTable extends Migration {

	public function up()
	{
		Schema::create('fin_movimentos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('pessoa_id')->unsigned();
			$table->integer('conta_id')->unsigned();
			$table->integer('classificacao_id')->unsigned();
			$table->string('tipo_movimento');
			$table->date('dtmovimento');
			$table->string('valor');
			$table->string('dtbaixa')->nullable();
			$table->string('desconto')->nullable();
			$table->string('multa')->nullable();
			$table->string('jutos')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('fin_movimentos');
	}
}