<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePessoasTable extends Migration {

	public function up()
	{
		Schema::create('pessoas', function(Blueprint $table) {
			$table->increments('id');
			$table->string('tipo_pessoa');
			$table->string('cpf')->nullable();
			$table->string('cnpj')->nullable();
			$table->string('nome_curto')->nullable();
			$table->string('nome_completo');
			$table->string('cep')->nullable();
			$table->string('logradouro')->nullable();
			$table->string('numero')->nullable();
			$table->string('bairro')->nullable();
			$table->string('complemento')->nullable();
			$table->string('cidade')->nullable();
			$table->string('uf')->nullable();
			$table->string('telefone')->nullable();
			$table->string('celular')->nullable();
			$table->string('whatsapp')->nullable();
			$table->string('email')->nullable();
			$table->string('site')->nullable();
			$table->string('certificado_digital')->nullable();
			$table->string('pais');
			$table->string('ativo', 3)->default('SIM');
			$table->longText('obs')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('pessoas');
	}
}