<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecommendationsTable extends Migration {

	public function up()
	{
		Schema::create('recommendations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('responsible', 100)->nullable();
			$table->string('longitude', 255)->nullable();
			$table->string('latitude', 255)->nullable();
			$table->text('comment')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('recommendations');
	}
}