<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Recommendation extends Eloquent {

	protected $table = 'recommendations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'responsible', 'longitude', 'latitude', 'comment');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

}