<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAreasTable extends Migration {

	public function up()
	{
		Schema::create('areas', function(Blueprint $table) {
			$table->increments('id');
			$table->string('responsible', 150)->nullable();
			$table->string('responsible_en', 150)->nullable();
			$table->string('start_from', 50)->nullable();
			$table->string('start_from_en', 50)->nullable();
			$table->string('ends_at', 50)->nullable();
			$table->string('ends_at_en', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->string('responsible_email', 150)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('areas');
	}
}