<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('role_id');
			$table->string('name', 50)->nullable();
			$table->boolean('inform')->default(0);
			$table->timestamps();
			$table->boolean('is_logged_in')->default(0);
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}