<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayoutTable extends Migration {

	public function up()
	{
		Schema::create('payout', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('pay_from', 120)->nullable();
			$table->string('pay_to', 120);
			$table->enum('bonus_type', array('Video', 'Referal', ''))->index();
			$table->string('description');
			$table->integer('amount');
			$table->datetime('pay_date');
			$table->timestamps();
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('payout');
	}
}