<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->text('content');
			$table->enum('sentiment', array('positive', 'negative', 'neutral'));
			$table->boolean('sent')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}