<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubCategoryTable extends Migration {

	public function up()
	{
		Schema::create('sub_category', function(Blueprint $table) {
			$table->uuid('id')->primary();
			$table->string('name', 255);
			$table->string('category_id');
			$table->boolean('status')->default(0);
			$table->timestamps();
			$table->softDeletes();
			$table->string('image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('sub_category');
	}
}