<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function sub_categories()
	{
		return $this->hasMany('SubCategory');
	}

	public function user_tracking()
	{
		return $this->hasMany('UserTracking');
	}

}