<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SubCategory extends Eloquent {

	protected $table = 'sub_category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category_data()
	{
		return $this->hasOne('Category');
	}

	public function inner_categories()
	{
		return $this->hasMany('InnerCategory');
	}

	public function user_tracking()
	{
		return $this->hasMany('UserTracking');
	}

}