<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Promocoes extends Model 
{

    protected $table = 'promocoes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nome', 'premio', 'valor_cupom', 'data_inicial', 'data_final', 'sorteio_data_inicial', 'sorteio_data_final', 'ativo');

    public function empresa()
    {
        return $this->belongsTo('Empresas', 'empresas_id');
    }

    public function cupons()
    {
        return $this->hasMany('Cupons', 'cupons_id');
    }

}