<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cupons extends Model 
{

    protected $table = 'cupons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nota_fiscal', 'data_compra', 'valor_compra', 'data_impressao', 'quantidade_cupons', 'observacao', 'ativo');

    public function promocao()
    {
        return $this->belongsTo('Promocoes', 'promocoes_id');
    }

    public function cliente()
    {
        return $this->belongsTo('Clientes', 'clientes_id');
    }

}