<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permissions_id')->references('permissions_id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('roles_id')->references('roles_id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('roles_id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('users_id')->references('users_id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('secoes', function(Blueprint $table) {
			$table->foreign('users_id')->references('users_id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tecnicos', function(Blueprint $table) {
			$table->foreign('users_id')->references('users_id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('empresas', function(Blueprint $table) {
			$table->foreign('contatos_id')->references('contatos_id')->on('contatos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('empresas', function(Blueprint $table) {
			$table->foreign('users_id')->references('users_id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clientes', function(Blueprint $table) {
			$table->foreign('contatos_id')->references('contatos_id')->on('contatos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clientes', function(Blueprint $table) {
			$table->foreign('empresas_id')->references('empresas_id')->on('empresas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('professores', function(Blueprint $table) {
			$table->foreign('contatos_id')->references('contatos_id')->on('contatos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('turmas', function(Blueprint $table) {
			$table->foreign('professores_id')->references('professores_id')->on('professores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('turmas', function(Blueprint $table) {
			$table->foreign('empresas_id')->references('empresas_id')->on('empresas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('aulas', function(Blueprint $table) {
			$table->foreign('horarios_id')->references('horarios_id')->on('horarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('aulas', function(Blueprint $table) {
			$table->foreign('turmas_id')->references('turmas_id')->on('turmas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matriculas', function(Blueprint $table) {
			$table->foreign('clientes_id')->references('clientes_id')->on('clientes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matriculas', function(Blueprint $table) {
			$table->foreign('turmas_id')->references('turmas_id')->on('turmas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('frequencias', function(Blueprint $table) {
			$table->foreign('aulas_id')->references('aulas_id')->on('aulas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('frequencias', function(Blueprint $table) {
			$table->foreign('matriculas_id')->references('matriculas_id')->on('matriculas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('promocoes', function(Blueprint $table) {
			$table->foreign('empresas_id')->references('empresas_id')->on('empresas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cupons', function(Blueprint $table) {
			$table->foreign('clientes_id')->references('clientes_id')->on('clientes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cupons', function(Blueprint $table) {
			$table->foreign('promocoes_id')->references('promocoes_id')->on('promocoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('log_atividades', function(Blueprint $table) {
			$table->foreign('secoes_id')->references('secoes_id')->on('secoes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permissions_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_roles_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_users_id_foreign');
		});
		Schema::table('secoes', function(Blueprint $table) {
			$table->dropForeign('secoes_users_id_foreign');
		});
		Schema::table('tecnicos', function(Blueprint $table) {
			$table->dropForeign('tecnicos_users_id_foreign');
		});
		Schema::table('empresas', function(Blueprint $table) {
			$table->dropForeign('empresas_contatos_id_foreign');
		});
		Schema::table('empresas', function(Blueprint $table) {
			$table->dropForeign('empresas_users_id_foreign');
		});
		Schema::table('clientes', function(Blueprint $table) {
			$table->dropForeign('clientes_contatos_id_foreign');
		});
		Schema::table('clientes', function(Blueprint $table) {
			$table->dropForeign('clientes_empresas_id_foreign');
		});
		Schema::table('professores', function(Blueprint $table) {
			$table->dropForeign('professores_contatos_id_foreign');
		});
		Schema::table('turmas', function(Blueprint $table) {
			$table->dropForeign('turmas_professores_id_foreign');
		});
		Schema::table('turmas', function(Blueprint $table) {
			$table->dropForeign('turmas_empresas_id_foreign');
		});
		Schema::table('aulas', function(Blueprint $table) {
			$table->dropForeign('aulas_horarios_id_foreign');
		});
		Schema::table('aulas', function(Blueprint $table) {
			$table->dropForeign('aulas_turmas_id_foreign');
		});
		Schema::table('matriculas', function(Blueprint $table) {
			$table->dropForeign('matriculas_clientes_id_foreign');
		});
		Schema::table('matriculas', function(Blueprint $table) {
			$table->dropForeign('matriculas_turmas_id_foreign');
		});
		Schema::table('frequencias', function(Blueprint $table) {
			$table->dropForeign('frequencias_aulas_id_foreign');
		});
		Schema::table('frequencias', function(Blueprint $table) {
			$table->dropForeign('frequencias_matriculas_id_foreign');
		});
		Schema::table('promocoes', function(Blueprint $table) {
			$table->dropForeign('promocoes_empresas_id_foreign');
		});
		Schema::table('cupons', function(Blueprint $table) {
			$table->dropForeign('cupons_clientes_id_foreign');
		});
		Schema::table('cupons', function(Blueprint $table) {
			$table->dropForeign('cupons_promocoes_id_foreign');
		});
		Schema::table('log_atividades', function(Blueprint $table) {
			$table->dropForeign('log_atividades_secoes_id_foreign');
		});
	}
}