<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInteractionsTable extends Migration {

	public function up()
	{
		Schema::create('interactions', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name')->nullable();
			$table->enum('type', array('text', 'question', 'options', 'location', 'image', 'video'));
			$table->bigInteger('conversation_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('interactions');
	}
}