<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHomeSaleLegalProtectionsTable extends Migration {

	public function up()
	{
		Schema::create('home_sale_legal_protections', function(Blueprint $table) {
			$table->uuid('uuid')->primary()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->string('upsellPurchasedBy')->nullable();
			$table->string('upsellPaymentTerms')->nullable();
			$table->double('upsellPrice')->nullable()->default('0');
			$table->timestamp('upsellPurchasedAt')->nullable();
			$table->timestamp('cancelledAt')->nullable();
			$table->string('cancellationReason')->nullable();
			$table->double('legalProtectionAmount')->nullable();
			$table->integer('yearsLegalProtection')->nullable();
			$table->integer('tier')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('home_sale_legal_protections');
	}
}