<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->uuid('uuid')->primary()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->string('agentEntryToken');
			$table->string('sellerEntryToken');
			$table->string('orderedBy');
			$table->date('closingDate')->nullable();
			$table->timestamp('closingInfoReminderLastSentAt')->nullable();
			$table->string('coordinatorEmailAddress')->nullable();
			$table->boolean('isArchived')->default(false);
			$table->boolean('disableClosingInfoReminders')->default(false);
			$table->timestamp('signatureReminderLastSentAt')->nullable();
			$table->boolean('disableSignatureReminders')->default(false);
			$table->boolean('isFinalized')->default(false);
			$table->boolean('isRexOrder')->default(false);
			$table->string('paymentTerms')->nullable()->default('Billed separately');
			$table->timestamp('paymentReceivedAt')->nullable();
			$table->integer('percentSDNComplete')->nullable()->default('0');
			$table->double('price')->nullable();
			$table->string('primaryDisclosureForm')->nullable();
			$table->string('promoCode')->nullable();
			$table->timestamp('awaitingSignaturesSdnStatusLastSetAt')->nullable();
			$table->timestamp('postDisclosureUpsellFirstViewedByPrimarySellerAt')->nullable();
			$table->timestamp('prepareToSignPageFirstViewedByPrimarySellerAt')->nullable();
			$table->string('status')->nullable()->default('created');
			$table->integer('statusPriority')->nullable()->default('1');
			$table->string('solutionPurchased')->nullable()->default('SST');
			$table->string('stripeChargeId')->nullable();
			$table->string('titleCompanyName')->nullable();
			$table->string('ziplogixTransactionId')->nullable();
			$table->string('zohoId')->nullable();
			$table->string('quickbooksInvoiceId')->nullable();
			$table->boolean('ignoreInReportsAuto')->default(false);
			$table->boolean('ignoreInReportsManual')->default(false);
			$table->string('additionalLegalOwners')->nullable();
			$table->string('segment')->nullable();
			$table->string('referringPlatformReturnUrl')->nullable();
			$table->string('referringPlatformListingId')->nullable();
			$table->jsonb('agentWithoutAccount')->nullable();
			$table->string('eulaAcceptedByIp')->nullable();
			$table->timestamp('eulaAcceptedAt')->nullable();
			$table->uuid('agentUuid')->nullable();
			$table->uuid('brokerUuid')->nullable();
			$table->uuid('referringPlatformUuid')->nullable();
			$table->uuid('propertyUuid')->nullable();
			$table->uuid('disclosureUuid')->nullable();
			$table->uuid('escrowOfficerUuid')->nullable();
			$table->uuid('hslpUuid')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}