<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSellersTable extends Migration {

	public function up()
	{
		Schema::create('sellers', function(Blueprint $table) {
			$table->uuid('uuid')->primary()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->string('emailAddress')->nullable();
			$table->string('firstName')->nullable();
			$table->string('lastName')->nullable();
			$table->string('phone')->nullable();
			$table->string('type')->nullable();
			$table->uuid('userUuid')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('sellers');
	}
}