<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('eleves', function(Blueprint $table) {
			$table->foreign('responsable_id')->references('id')->on('parentEleve')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('matiere_id')->references('id')->on('matieres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matieres', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categorie')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matieres', function(Blueprint $table) {
			$table->foreign('id_classe')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matiere_professeur', function(Blueprint $table) {
			$table->foreign('professeur_id')->references('id')->on('professeurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matiere_professeur', function(Blueprint $table) {
			$table->foreign('matiere_id')->references('id')->on('matieres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inscriptions', function(Blueprint $table) {
			$table->foreign('annee_academique')->references('id')->on('annee_academique')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inscriptions', function(Blueprint $table) {
			$table->foreign('classe')->references('id')->on('classes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('inscriptions', function(Blueprint $table) {
			$table->foreign('id_eleve')->references('id')->on('eleves')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('eleves', function(Blueprint $table) {
			$table->dropForeign('eleves_responsable_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_matiere_id_foreign');
		});
		Schema::table('matieres', function(Blueprint $table) {
			$table->dropForeign('matieres_categorie_id_foreign');
		});
		Schema::table('matieres', function(Blueprint $table) {
			$table->dropForeign('matieres_id_classe_foreign');
		});
		Schema::table('matiere_professeur', function(Blueprint $table) {
			$table->dropForeign('matiere_professeur_professeur_id_foreign');
		});
		Schema::table('matiere_professeur', function(Blueprint $table) {
			$table->dropForeign('matiere_professeur_matiere_id_foreign');
		});
		Schema::table('inscriptions', function(Blueprint $table) {
			$table->dropForeign('inscriptions_annee_academique_foreign');
		});
		Schema::table('inscriptions', function(Blueprint $table) {
			$table->dropForeign('inscriptions_classe_foreign');
		});
		Schema::table('inscriptions', function(Blueprint $table) {
			$table->dropForeign('inscriptions_id_eleve_foreign');
		});
	}
}