<?php

namespace Guides;

class Question extends Eloquent {

	protected $table = 'guide_questions';
	public $timestamps = true;

	public function bucket()
	{
		return $this->hasMany('Bucket', 'question_id', 'id');
	}

	public function guide()
	{
		return $this->belongsTo('Guide', 'guide_id', 'id');
	}

	public function localQuestion()
	{
		return $this->hasOne('LocalQuestion', 'question_id', 'id');
	}

	public function guideDocument()
	{
		return $this->hasMany('GuideDocument', 'question_id', 'id');
	}

}