<?php

namespace Guides;

class Guide extends Eloquent {

	protected $table = 'guide_guides';
	public $timestamps = true;

	public function year()
	{
		return $this->hasMany('Year', 'guide_id', 'id');
	}

	public function period()
	{
		return $this->hasMany('Period', 'guide_id', 'id');
	}

	public function week()
	{
		return $this->hasOne('Week', 'guide_id', 'id');
	}

	public function bucket()
	{
		return $this->hasMany('Bucket', 'guide_id', 'id');
	}

	public function question()
	{
		return $this->hasMany('Question', 'guide_id', 'id');
	}

	public function documents()
	{
		return $this->hasMany('GuideDocument', 'guide_id', 'id');
	}

	public function localGuide()
	{
		return $this->hasOne('LocalGuide', 'guide_id', 'id');
	}

}