<?php

namespace Guides;

use Illuminate\Database\Eloquent\Model;

class Period extends Model 
{

    protected $table = 'guide_periods';
    public $timestamps = true;

    public function guide()
    {
        return $this->hasOne('Guide', 'guide_id', 'id');
    }

    public function Week()
    {
        return $this->hasMany('Week', 'period_id', 'id')->with('periods_weeks');
    }

    public function localPeriod()
    {
        return $this->hasOne('LocalPeriod', 'period_id', 'id');
    }

}