<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 20);
			$table->string('userName', 20);
			$table->string('type', 20);
			$table->string('email', 30);
			$table->bigInteger('role_id')->unsigned()->default('1');
			$table->timestamp('email_verified_at');
			$table->string('password', 30);
			$table->string('password_confirmation', 30)->nullable();
			$table->string('phone', 20);
			$table->enum('status', array('active', 'block'));
			$table->string('birth', 30)->nullable();
			$table->enum('gender', array('male', 'female'));
			$table->string('language', 20)->nullable()->default('ar');
			$table->string('theme_mode', 20)->nullable()->default('light');
			$table->timestamps();
			$table->string('title', 20)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}