<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('branch_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->integer('offer_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->integer('sub_service_id')->unsigned();
			$table->string('month', 191);
			$table->date('day');
			$table->tinyInteger('slot');
			$table->string('time', 191);
			$table->enum('status', array('available', 'canceled', 'confirmed', 'reserved'));
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}