<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('address', 191);
			$table->string('longitude', 191);
			$table->string('latitude', 191);
			$table->string('timing_from', 191);
			$table->string('timing_to', 191);
			$table->string('image', 191);
			$table->integer('city_id')->unsigned();
			$table->integer('clinic_id')->unsigned();
			$table->string('logo', 191);
			$table->string('fb_link', 191);
			$table->string('snapchat_link', 191);
			$table->string('instagram_link', 191);
			$table->string('twitter_link', 191);
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}