<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('upazila_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('union_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('farmers', function(Blueprint $table) {
			$table->foreign('upazila_id')->references('id')->on('locations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_upazila_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_union_id_foreign');
		});
		Schema::table('farmers', function(Blueprint $table) {
			$table->dropForeign('farmers_upazila_id_foreign');
		});
	}
}