<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFarmersTable extends Migration {

	public function up()
	{
		Schema::create('farmers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('upazila_id')->unsigned();
			$table->mediumInteger('union_id');
			$table->bigInteger('nid');
			$table->string('name', 100);
			$table->string('phone', 20);
			$table->text('address');
			$table->timestamps();
			$table->bigInteger('created_by');
			$table->string('created_by_ip', 15);
			$table->bigInteger('updated_by')->nullable();
			$table->string('updated_by_ip', 15)->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('farmers');
	}
}