<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Stockin extends Model 
{

    protected $table = 'stockin';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('item_id', 'quantity', 'amount', 'date', 'user_id');

    public function item()
    {
        return $this->belongsTo('Items', 'item_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}