<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CapitalReports extends Model 
{

    protected $table = 'capital_reports';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('expense_item', 'amount', 'date', 'notes', 'capital_id');

    public function capital()
    {
        return $this->belongsTo('Capitals', 'capital_id');
    }

}