<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Expenses extends Model 
{

    protected $table = 'expenses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('site_id', 'amount', 'date', 'note', 'type', 'expense_item');

    public function site()
    {
        return $this->belongsTo('Sites', 'site_id');
    }

}