<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Salary extends Model 
{

    protected $table = 'salary';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('month', 'employee_id', 'total_hours', 'deduction', 'loan', 'site_id', 'total', 'salary', 'total_days');

    public function employee()
    {
        return $this->belongsTo('Employees', 'employee_id');
    }

    public function site()
    {
        return $this->belongsTo('Sites', 'site_id');
    }

}